#if !defined(AFX_CONFIGDATA_H__06BA3180_6EB4_11D2_8F2A_91728893B80B__INCLUDED_)
#define AFX_CONFIGDATA_H__06BA3180_6EB4_11D2_8F2A_91728893B80B__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "error.h"
#include "misc.h"

typedef struct killtext_t {
	int				weapon;
	char*			text;
	killtext_t*		next;
} killtext_t;

typedef struct clan_id_t {
	char*			id;
	clan_id_t*		next;
} clan_id_t;

typedef struct clan_t {
	char*			name;
	clan_id_t*		ids;
	clan_t*			next;
} clan_t;

typedef struct weapon_t {
	int				number;
	char*			name;
	weapon_t*		next;
} weapon_t;

typedef struct deathtype_t {
	int				number;
	char*			name;
	deathtype_t*	next;
} deathtype_t;

enum sort_t { so_name, so_clan, so_frags, so_kills, so_waskilled, so_ratio, so_deaths, 
			  so_total_deaths, so_suicides, so_fph, so_kph, so_dph, so_team, so_ctf_score,
			  so_lifetime_longest, so_lifetime_average, so_mkiol, so_skill, so_quadtime,
			  so_quadkills, so_memberkills };

enum gametype_t { gt_none, gt_dm2, gt_log, gt_qwd, gt_dem };

enum option_t { kill, weapon, deathtype, html_open, clan };

typedef enum msgtype { y_kills_x, x_kills_y, selfkill, death, extra_frags, flag_captures, 
	flag_stolen, flag_losses, flag_return, ctf_defend_flag, ctf_defend_base, 
	ctf_defend_flagcarrier,	ctf_defend_aggressive, flagcarrier_frag, ctf_assists, 
	ctf_helped_return }; 

const int msgtype_count = 16; // change this if msgtype added!!!

class configdata  
{
public:
	int				get_clan_count ();
	int				get_weapon_count ();
	int				get_deathtype_count ();
	clan_t*			get_clan(int num);
	weapon_t*		get_weapon(int num);
	deathtype_t*	get_deathtype(int num);
	void			get_configpath (char* configpath, char* execstr);
	char*			get_temppath ();
	void			read_options (int argc, char** argv);
	void			read_configfile(char* pathstr);
	killtext_t*		get_first_Q2_msg (int type);
	killtext_t*		get_first_QW_msg (int type);
	configdata ();
	virtual ~configdata	();
private:
	void parse_clan_data();
	void			add_clan_id (char* name, char* id); // if (!frozen)
	void			add_weapon(weapon_t* weapon); // if (!frozen)
	void			add_deathtype(deathtype_t* deathtype); // if (!frozen)
	int				clan_count;
	int				weapon_count;
	int				deathtype_count;
	clan_t*			clans;
	clan_t*			first_clan;
	clan_t*			current_clan;
	clan_t*			last_clan;
	weapon_t*		weapons;
	weapon_t*		first_weapon;
	weapon_t*		current_weapon;
	weapon_t*		last_weapon;
	deathtype_t*	deathtypes;
	deathtype_t*	first_deathtype;
	deathtype_t*	current_deathtype;
	deathtype_t*	last_deathtype;
	void			parse_weapon_data();
	void			parse_deathtype_data();
	misc*			misc;
	error*			err;
	char			html_open_command[260];
//	char*			configpath;
	char*			buf;
	int				buflen;
	void			add(killtext_t** x, char* killtext, int weapon);
	void			search_option(char* kstr, option_t type, ...);
	char*			read_string(char* buf, int& pos);
	int				read_int(char* buf, int& pos);
	void			parse_data();
	killtext_t**	first_Q2_msg;
	killtext_t**	last_Q2_msg;
	killtext_t**	current_Q2_msg;
	killtext_t**	first_QW_msg;
	killtext_t**	last_QW_msg;
	killtext_t**	current_QW_msg;
public:
	int top_x_players;
	int kills_by_weapons;
	gametype_t gametype;
	bool centerprint;
	bool no_times;
	bool no_claninfo;
	bool no_killcharts;
	char* get_open_command(char* filename);
	bool temp_output;
	bool open_all;
	bool open_graphs;
	bool open_results;
	bool open_logs;
	bool write_idda_log;
	bool write_console_log;
	bool write_console_log_html;
	bool write_kills_per_time_graph;
	bool write_ways_and_kills_graph;
	bool write_graph;
	bool graph_all_clients;
	bool dont_del_nps;
	bool weaponkills;
	bool single;
	bool html;
	bool onehtml;
	bool userconfig;
	bool is_lmctf;
	bool is_battle;
	int shortlen;
	sort_t sortorder_players[2];
	char userconfigfile[260];
	char htmlfile[260];
};

#endif // !defined(AFX_CONFIGDATA_H__06BA3180_6EB4_11D2_8F2A_91728893B80B__INCLUDED_)
